// ContentsEscL.cpp : CContentsEscL Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEscL, CObject, 1)



// Serialize draw data
void CContentsEscL::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEscL::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,m_Data.cLineStyle) ;
	CPen *pOldPen = pDC->SelectObject((CPen* )&Pen);

	int OldBkMode = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));

	pDC->MoveTo(m_Data.iX1,m_Data.iY1);
	pDC->LineTo(m_Data.iX2,m_Data.iY2);


	pDC->SetBkMode( OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
}

// Transmit the data to GP
int CContentsEscL::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_L(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iX1,m_Data.iY1,m_Data.iX2,m_Data.iY2)) ;
}
